/***************************************************************************************************
 *                                     ACH WiFi SDK
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     wifi_app.c
 * @brief    WiFi application.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

/*system includes.*/
#include "ach118x.h"
#include <ctype.h>
#include <stdio.h>

/*GKI header file*/
#include "GKI_uart.h"
#include "GKI_sys.h"

/*freertos includes.*/
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "semphr.h"
#include "timers.h"

/* wlan API */
#include "wlan_def.h"
#include "wlan_com.h"
#include "wlan_config.h"
#include "wlan_driver.h"
#include "wlan_sys.h"

/* AT cmds */
#include "AtCmd.h"

/* WiFi includes */
#include "wifi_app.h"

#ifdef AMP_SDK_EXAMPLE
/* amp_example test include */
#include "amp_example.h"
#endif

/*********************************************************************
* User task
**********************************************************************/
#define USER_TASK_PRIORITY 5
void vUserTask(void *arg)
{
    wlan_ap_t ap;

    strcpy((char *)ap.ssid,     "NETGEAR85");       // Your WiFi router
    strcpy((char *)ap.password, "1234567689012");   // Your password

    for (;;)
    {
        vTaskDelay(1000);
        if (NO_ERR == wlan_sta_join(&ap))
        {
            vTaskDelete(NULL);
        }
    }
}


/**************************
* Start of SDK Application
***************************/
void Application(void)
{
    /******************************
    * Initialize the WiFi
    *******************************/
    Wifi_Init();

    /***********************************
    * Put your task definitions here
    ************************************/
    //xTaskCreate(vUserTask, "User-Task", 300, NULL, USER_TASK_PRIORITY, NULL);

#ifdef AMP_SDK_EXAMPLE
    // Add your AT commands
    AddAtCmd("test", (void *)&AT_Test);

    // for signal binding test
    xTaskCreate(vAppMainTask, "AppMain", 2048, NULL, 4, NULL);
#endif

    /***********************************
    * Start the scheduler and WiFi task
    ************************************/
    vTaskStartScheduler();
}
