/***************************************************************************************************
 *                                   MCU ACH118X SDK
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     main.c
 * @brief    Main starting routine.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

#include "ach118x.h"
#include <stdio.h>
#include "GKI_sys.h"

// Private function prototypes
void SystemClockConfig(void);
void Application(void);

//------------------------------------------------------------------------
// Main loop
//------------------------------------------------------------------------
int main(void)
{
    // Get system clock
    SystemClockConfig();

    // Set CPU clock speed
    GKI_SetCpuMhz(200);

    // Setup UART
    UART_InitTypeDef uartStruct;
    uartStruct.UART_BaudRate            = 115200;
    uartStruct.UART_HardwareFlowControl = UART_FLOWCON_DISABLE;
    uartStruct.UART_Parity              = UART_NONE_PARITY;
    uartStruct.UART_StopBits            = UART_STOP_1;
    uartStruct.UART_WordLength          = UART_LEN_8;
    UART_Init((UART_Typedef *)UART0_REG_BASE, &uartStruct);

    // run application
    Application();
}

//------------------------------------------------------------------------
// System Clock Configuration
//------------------------------------------------------------------------
static void SystemClockConfig(void)
{
    // Get system core clock Hz (this is required)
    SystemCoreClock = util_GetMainFreq();
}

/************************ (C) COPYRIGHT ART *****END OF FILE****/

