/****************************************************************************************
 *                              MCU ACH118X driver library
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     hardfault_dump.h
 * @brief    Dump register values on hard faults.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ****************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>


//----------------------------------------------------------------------------
// Useful for determining the source of HardFaults
//   pc contains the address of the instruction causing the HardFault
//----------------------------------------------------------------------------
void prvGetRegistersFromStack( uint32_t *pulFaultStackAddress )
{
    /* These are volatile to try and prevent the compiler/linker optimising them
    away as the variables never actually get used.  If the debugger won't show the
    values of the variables, make them global my moving their declaration outside
    of this function. */
    volatile uint32_t r0;
    volatile uint32_t r1;
    volatile uint32_t r2;
    volatile uint32_t r3;
    volatile uint32_t r12;
    volatile uint32_t lr; /* Link register. */
    volatile uint32_t pc; /* Program counter. */
    volatile uint32_t psr;/* Program status register. */

    r0  = pulFaultStackAddress[ 0 ];
    r1  = pulFaultStackAddress[ 1 ];
    r2  = pulFaultStackAddress[ 2 ];
    r3  = pulFaultStackAddress[ 3 ];
    r12 = pulFaultStackAddress[ 4 ];
    lr  = pulFaultStackAddress[ 5 ];
    pc  = pulFaultStackAddress[ 6 ];
    psr = pulFaultStackAddress[ 7 ];

    /* When the following line is hit, the variables contain the register values. */
    //PANIC("HardFault");
    printf("HardFault\r\n");
    printf("r0  0x%08X\r\n", r0);
    printf("r1  0x%08X\r\n", r1);
    printf("r2  0x%08X\r\n", r2);
    printf("r3  0x%08X\r\n", r3);
    printf("r12 0x%08X\r\n", r12);
    printf("lr  0x%08X\r\n", lr);
    printf("pc  0x%08X\r\n", pc);
    printf("psr 0x%08X\r\n", psr);
    //BP_ShowPoolData();
    //NVIC_SystemReset();
    for( ;; );
}
/************************ (C) COPYRIGHT ART *****END OF FILE****/

