/***************************************************************************************************
 *                                     ACH WiFi SDK
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     AtCmd.c
 * @brief    Functions used to extend the AT Commands.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

#include "AtCmd.h"


#define CMD_MAX 9
static void * CmdText[CMD_MAX];
static void * CmdFunc[CMD_MAX];

/**
  * @brief  Add a command to the AT commands
  * @param  s: Static string of command
  * @param  f: void function(char **ppBuf)
  * @retval none
  */
void AddAtCmd(char *s, void *f)
{
    if (ExtCommandNum<CMD_MAX)
    {
        CmdText[ExtCommandNum] = s;
        CmdFunc[ExtCommandNum] = f;
        ExtCommandText = CmdText;
        ExtCommandFunc = CmdFunc;
        ExtCommandNum++;
    }
}

