/*********************************************************************************************************                                               
*                                          ACH Test Suite
*                             COPYRIGHT(c) 2019 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : menu.c
* Version : V1.0.0
* Brief   : Menu driver
**********************************************************************************************************/
#ifndef __MENU_H
#define __MENU_H

#define KEY_TIMEOUT_MS 3000

#define ITEM_TYPE_NORMAL    0   // normal
#define ITEM_TYPE_YESNO     1   // ask are you sure
#define ITEM_TYPE_MENU      2   // another menu


typedef void(*pMenuFunc_t)(void);
typedef struct {
    u8  type;
    u8  refresh;
    char *Text;
    void *pFunc;
} MenuItemTypedef;

typedef struct {
    char *Title;
    MenuItemTypedef *Items;
} MenuTypedef;

extern u32 MenuTimerMS;


//------------------------------------------
// Prototypes
//------------------------------------------
void menu_start(MenuTypedef *m);
void NotImplemented(void);
void InvalidSelection(void);
u8   CharIsReady(void);
void crlf(void);
void putstring_crlf(char *s);
void ShowMenuItemNum(int i);
int  GetMenuItemNum(int ch);
u32  _atoi(char *s);
char* _itoa(int n, char *s);


#endif // __MENU_H
