#ifdef AMP_SDK_EXAMPLE

#ifndef __SIGNAL_TEST_H__
#define __SIGNAL_TEST_H__

#include <stdint.h>
#include "sdk_signal_mnt.h"

// for test
#define AMP_SYS_LOG(fmt, ...) \
    printf("[%s:%d]" fmt "\n", __FUNCTION__, __LINE__, ##__VA_ARGS__)

/**
 * @brief Payload for SIG_SDK_UART_DATA_RX
 */
typedef struct {
    uint16_t    len;                // Length of received data
    uint8_t     data[0];            // Pointer to RX buffer
} app_uart_rx_event_t;

typedef struct {
#define AMP_NETWORK_STATUS_JOIN_FAILED     0x00
#define AMP_NETWORK_STATUS_JOIN_SUCCESS    0x01
    uint8_t join_status;      // join status
} amp_network_status_t;

// ==========================================
// Exported Functions
// ==========================================

/**
 * @brief Application Main Task entry point.
 * @param pvParameters Task parameters (unused).
 */
void vAppMainTask(void *pvParameters);

/*
 * mqtt_example_task
 */
void mqtt_example_task(void *pvParameters);

/*
 * wlan_sta_start
 */
int test_wlan_sta_example(int word_count, char **words);

/*
 * for AT command test function
 */
void AT_Test(char **ppBuf);

#endif /* __SIGNAL_TEST_H__ */

#endif // AMP_SDK_EXAMPLE
