/***************************************************************************************************
 *                                     ACH WiFi SDK
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     AtCmd.h
 * @brief    Header used for extending AT Commands.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __ATCMD_H
#define __ATCMD_H

//--------------------------------------
// Vars used to extend AT commands
//--------------------------------------
extern int    ExtCommandNum;    // Number of extended AT commands
extern void **ExtCommandText;   // Handle to the text list of the commands
extern void **ExtCommandFunc;   // Handle to the function list of the commands

/**
  * @brief  Add a command to the AT commands
  * @param  s: Static string of command
  * @param  f: void function(char **ppBuf)
  * @retval none
  */
void AddAtCmd(char *s, void *f);

#endif // __ATCMD_H

